/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import io.wispforest.owo.Owo;
import io.wispforest.owo.ui.core.Animatable;
import io.wispforest.owo.ui.parsing.UIModelParsingException;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_3532;
import org.w3c.dom.Element;

public class Sizing
implements Animatable<Sizing> {
    private static final Sizing CONTENT_SIZING = new Sizing(0, Method.CONTENT);
    public final Method method;
    public final int value;

    private Sizing(int value, Method method) {
        this.method = method;
        this.value = value;
    }

    public int inflate(int space, Function<Sizing, Integer> contentSizeFunction) {
        return switch (this.method) {
            default -> throw new IncompatibleClassChangeError();
            case Method.FIXED -> this.value;
            case Method.FILL -> Math.round((float)this.value / 100.0f * (float)space);
            case Method.CONTENT -> contentSizeFunction.apply(this) + this.value * 2;
        };
    }

    public static Sizing fixed(int value) {
        return new Sizing(value, Method.FIXED);
    }

    public static Sizing content() {
        return CONTENT_SIZING;
    }

    public static Sizing content(int padding) {
        return new Sizing(padding, Method.CONTENT);
    }

    public static Sizing fill(int percent) {
        return new Sizing(percent, Method.FILL);
    }

    public boolean isContent() {
        return this.method == Method.CONTENT;
    }

    @Override
    public Sizing interpolate(Sizing next, float delta) {
        if (next.method != this.method) {
            Owo.LOGGER.warn("Cannot interpolate between sizing with method " + this.method + " and " + next.method);
            return this;
        }
        return new Sizing((int)class_3532.method_16439((float)delta, (float)this.value, (float)next.value), this.method);
    }

    public static Sizing parse(Element sizingElement) {
        String methodString = sizingElement.getAttribute("method");
        if (methodString.isBlank()) {
            throw new UIModelParsingException("Missing 'method' attribute on sizing declaration. Must be one of: fixed, content, fill");
        }
        Method method = Method.valueOf(methodString.toUpperCase(Locale.ROOT));
        String value = sizingElement.getTextContent().strip();
        if (method == Method.CONTENT) {
            if (!value.matches("(-?\\d+)?")) {
                throw new UIModelParsingException("Invalid value in sizing declaration");
            }
            return new Sizing(value.isEmpty() ? 0 : Integer.parseInt(value), method);
        }
        if (!value.matches("-?\\d+")) {
            throw new UIModelParsingException("Invalid value in sizing declaration");
        }
        return new Sizing(Integer.parseInt(value), method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sizing sizing = (Sizing)o;
        return this.value == sizing.value && this.method == sizing.method;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.value});
    }

    public static enum Method {
        FIXED,
        CONTENT,
        FILL;

    }
}

